/*
 * Decompiled with CFR 0.152.
 */
package com.x310.clarity.modules;

import com.x310.clarity.Main;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import meteordevelopment.meteorclient.events.render.Render2DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.Renderer2D;
import meteordevelopment.meteorclient.renderer.text.TextRenderer;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.config.Config;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.misc.NameProtect;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.render.NametagUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.joml.Vector3d;

public class ClarityNametags
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgPlayers;
    private final SettingGroup sgRender;
    private final Setting<SettingColor> nameColor;
    private final Color RED;
    private final Color GREEN;
    private final Color AMBER;
    private final Color background;
    private final Setting<Double> scale;
    private final List<class_1297> entityList;
    private final Setting<Boolean> culling;
    private final Setting<Integer> maxCullCount;
    private final Setting<Boolean> displayHealth;
    private final Vector3d pos;

    public ClarityNametags() {
        super(Main.CATEGORY, "Claritytags", "clarity nametag fr");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgPlayers = this.settings.createGroup("Players");
        this.sgRender = this.settings.createGroup("Render");
        this.nameColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("name-color")).description("The color of the nametag names.")).defaultValue(new SettingColor()).build());
        this.RED = new Color(255, 25, 25);
        this.GREEN = new Color(25, 255, 25);
        this.AMBER = new Color(255, 105, 25);
        this.background = new Color(50, 50, 50, 255);
        this.scale = this.sgGeneral.add((Setting)((DoubleSetting.Builder)new DoubleSetting.Builder().name("Scale")).defaultValue(1.0).build());
        this.entityList = new ArrayList<class_1297>();
        this.culling = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Culling")).defaultValue((Object)false)).build());
        this.maxCullCount = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Max Cull Count")).defaultValue((Object)20)).build());
        this.displayHealth = this.sgPlayers.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("health")).description("Shows the player's health.")).defaultValue((Object)true)).build());
        this.pos = new Vector3d();
    }

    private int getRenderCount() {
        int count = (Boolean)this.culling.get() != false ? ((Integer)this.maxCullCount.get()).intValue() : this.entityList.size();
        count = class_3532.method_15340((int)count, (int)0, (int)this.entityList.size());
        return count;
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        this.entityList.clear();
        class_243 cameraPos = this.mc.field_1773.method_19418().method_19326();
        assert (this.mc.field_1687 != null);
        for (class_1297 entity : this.mc.field_1687.method_18112()) {
            if (!(entity instanceof class_1657) || entity == this.mc.field_1724) continue;
            this.entityList.add(entity);
        }
        this.entityList.sort(Comparator.comparingDouble(e -> e.method_5707(cameraPos)));
    }

    private void drawBg(double x, double y, double width, double height) {
        Renderer2D.COLOR.begin();
        Renderer2D.COLOR.quad(x - 1.0, y - 1.0, width + 2.0, height + 2.0, this.background);
        Renderer2D.COLOR.quad(x, y, width, height, new Color(30, 30, 30, 255));
        Renderer2D.COLOR.quad(x, y - 2.0, width, 2.0, new Color(177, 205, 255, 255));
        Renderer2D.COLOR.render((class_4587)null);
    }

    private void renderNametagPlayer(Render2DEvent event, class_1657 player, boolean shadow) {
        TextRenderer text = TextRenderer.get();
        NametagUtils.begin((Vector3d)this.pos);
        Color nameColor = PlayerUtils.getPlayerColor((class_1657)player, (Color)((Color)this.nameColor.get()));
        String name = player == this.mc.field_1724 ? ((NameProtect)Modules.get().get(NameProtect.class)).getName(player.method_5477().getString()) : player.method_5477().getString();
        float absorption = player.method_6067();
        int health = Math.round(player.method_6032() + absorption);
        double healthPercentage = (double)health / (double)(player.method_6063() + absorption);
        String healthText = " " + health;
        Color healthColor = healthPercentage <= 0.333 ? this.RED : (healthPercentage <= 0.666 ? this.AMBER : this.GREEN);
        double nameWidth = text.getWidth(name, shadow);
        double healthWidth = text.getWidth(healthText, shadow);
        double width = nameWidth + ((Boolean)this.displayHealth.get() != false ? healthWidth : 0.0);
        double widthHalf = width / 2.0;
        double height = text.getHeight(shadow);
        text.beginBig();
        double hX = -widthHalf;
        double hY = -height;
        double heightDown = text.getHeight(shadow);
        this.drawBg(-widthHalf, -heightDown, width, heightDown);
        hX = text.render(name, hX, hY, nameColor, shadow);
        if (((Boolean)this.displayHealth.get()).booleanValue()) {
            text.render(healthText, hX, hY, healthColor, shadow);
        }
        text.end();
        NametagUtils.end();
    }

    private double getHeight(class_1297 entity) {
        double height = entity.method_18381(entity.method_18376());
        height = entity.method_5864() != class_1299.field_6052 && entity.method_5864() != class_1299.field_6043 ? (height += 0.5) : (height += 0.2);
        return height;
    }

    @EventHandler
    private void onRender2D(Render2DEvent event) {
        int count = this.getRenderCount();
        boolean shadow = (Boolean)Config.get().customFont.get();
        for (int i = count - 1; i > -1; --i) {
            class_1297 entity = this.entityList.get(i);
            Utils.set((Vector3d)this.pos, (class_1297)entity, (double)event.tickDelta);
            this.pos.add(0.0, this.getHeight(entity), 0.0);
            class_1299 type = entity.method_5864();
            if (!NametagUtils.to2D((Vector3d)this.pos, (double)((Double)this.scale.get())) || type != class_1299.field_6097) continue;
            this.renderNametagPlayer(event, (class_1657)entity, shadow);
        }
    }
}

